Attribute VB_Name = "physics"
'**************************************************
' RIGID BODY PHYSICS SIMULATION
'**************************************************
' David Brebner, Unlimited Realities (2001)
'**************************************************
' Modeled using particles with join
' Thanks to Jakobsen, Baraff, Mirtich, Witkin, Verlet
'
' note : verlet fixed time integration is used in
'        this simulation for stablility
'**************************************************

Public num_particles As Integer

Public num_join As Integer
Public join_p1(1000) As Long
Public join_p2(1000) As Long
Public join_rl(1000) As Long

Public m_curp(1000) As D3DVECTOR
'position right now

Public m_oldp(1000) As D3DVECTOR
'the old position

Public m_forc(1000) As D3DVECTOR
'Force accumulation

Public m_grav As D3DVECTOR
'Gravity

Public m_timeStep As Double
'the time between integrations

Public Function TimeStep()
    'this executed the requirements of the physics
    'simulation for the current timestep

    AccumulateForces

    Verlet

    'SatisfyConstraints
    SatisfyConstraints
    
    'Form1.Picture1.Cls
    'For a% = 1 To num_particles
    '    Form1.Picture1.Line (m_curp(a%).x + 100, m_curp(a%).y + 100)-Step(2, 2), 0, BF
    'Next

End Function

Private Function Verlet()
    Dim i As Integer
    Dim tmp As D3DVECTOR
    'time to increment the positions based on the applied forces
    'during the specified timestep...
    
    For i = 1 To num_particles
    
        tmp = m_curp(i)
        
        m_curp(i).x = (m_curp(i).x * 2 - m_oldp(i).x) + (m_forc(i).x * m_timeStep)
        m_curp(i).y = (m_curp(i).y * 2 - m_oldp(i).y) + (m_forc(i).y * m_timeStep)
        m_curp(i).z = (m_curp(i).z * 2 - m_oldp(i).z) + (m_forc(i).z * m_timeStep)
        
        m_oldp(i) = tmp
        
    Next

End Function

Private Function SatisfyConstraints()
    Dim delta As D3DVECTOR
    Dim vscale As Double
    Dim rl As Long
    
    'constrain the box to the ground..
    For i = 1 To num_particles
        If m_curp(i).y < 0 Then
            'we have hit the ground...
            m_curp(i).y = 0
            m_oldp(i).x = m_oldp(i).x + (m_curp(i).x - m_oldp(i).x) * 0.4
            m_oldp(i).z = m_oldp(i).z + (m_curp(i).z - m_oldp(i).z) * 0.4
        End If
    Next
        
    
    'constrain sticks based on there length
    For i = 1 To num_join

        D3DXVec3Subtract delta, m_curp(join_p2(i)), m_curp(join_p1(i))

        rl = join_rl(i) * join_rl(i)
        vscale = rl / (delta.x * delta.x + delta.y * delta.y + delta.z * delta.z + rl) - 0.5
    
        D3DXVec3Scale delta, delta, vscale

        D3DXVec3Subtract m_curp(join_p1(i)), m_curp(join_p1(i)), delta

        D3DXVec3Add m_curp(join_p2(i)), m_curp(join_p2(i)), delta
    

    Next
    



End Function

Private Function AccumulateForces()
    Dim i As Integer
    'All particles are influenced by gravity
    
    For i = 0 To num_particles
    
        m_forc(i) = m_grav
        
    Next

End Function





