Attribute VB_Name = "physics"
'**************************************************
' RIGID BODY PHYSICS SIMULATION
'**************************************************
' David Brebner, Unlimited Realities (2001)
'**************************************************
' Modeled using particles with join
' Thanks to Jakobsen, Baraff, Mirtich, Witkin, Verlet
'
' note : verlet fixed time integration is used in
'        this simulation for stablility
'**************************************************
Option Explicit

Public Type body_type
    Part_Min As Long
    Part_Max As Long
    Join_Max As Long
    Join_Min As Long
    
    bound_min As D3DVECTOR
    bound_max As D3DVECTOR
    
    centre_mass As D3DVECTOR
    
    mesh As Long
End Type

Public num_particles As Integer


Public body(100) As body_type
Public num_body As Integer

Public num_join As Integer
Public join_p1(1500) As Long
Public join_p2(1500) As Long
Public join_rl(1500) As Long

Public m_curp(800) As D3DVECTOR
'position right now

Public m_oldp(800) As D3DVECTOR
'the old position

Public m_forc(800) As D3DVECTOR
'Force accumulation

Public m_grav As D3DVECTOR
'Gravity

Public m_timeStep As Double
'the time between integrations

Public Function TimeStep()
    'this executed the requirements of the physics
    'simulation for the current timestep

    AccumulateForces

    Verlet

    DetectCollisions
        
    SatisfyConstraints
    

End Function

Private Function Verlet()
    Dim i As Integer
    Dim tmp As D3DVECTOR
    'time to increment the positions based on the applied forces
    'during the specified timestep...
    
    For i = 1 To num_particles
    
        tmp = m_curp(i)
        
        m_curp(i).x = (m_curp(i).x * 2 - m_oldp(i).x) + (m_forc(i).x * m_timeStep)
        m_curp(i).y = (m_curp(i).y * 2 - m_oldp(i).y) + (m_forc(i).y * m_timeStep)
        m_curp(i).z = (m_curp(i).z * 2 - m_oldp(i).z) + (m_forc(i).z * m_timeStep)
        
        m_oldp(i) = tmp
        
    Next

End Function
Private Function SatisfyConstraints()
    Dim delta As D3DVECTOR
    Dim vscale As Double
    Dim rl As Long, i As Long
    
    'constrain sticks based on there length
    For i = 1 To num_join

        D3DXVec3Subtract delta, m_curp(join_p2(i)), m_curp(join_p1(i))

        rl = join_rl(i) * join_rl(i)
        vscale = rl / (delta.x * delta.x + delta.y * delta.y + delta.z * delta.z + rl) - 0.5
    
        D3DXVec3Scale delta, delta, vscale

        D3DXVec3Subtract m_curp(join_p1(i)), m_curp(join_p1(i)), delta

        D3DXVec3Add m_curp(join_p2(i)), m_curp(join_p2(i)), delta
    Next
    
End Function

Private Function AccumulateForces()
    Dim i As Integer
    'All particles are influenced by gravity
    
    For i = 0 To num_particles
    
        m_forc(i) = m_grav
        
    Next

End Function

Private Function DetectCollisions()
    'collide with the ground...
    Dim i As Long
    Dim j As Long
    Dim a As Long
    Dim delta As D3DVECTOR
    
    For i = 1 To num_particles
        If m_curp(i).y < 0 Then
            'we have hit the ground...
            m_curp(i).y = 0
            m_oldp(i).x = m_oldp(i).x + (m_curp(i).x - m_oldp(i).x) * 0.4
            m_oldp(i).z = m_oldp(i).z + (m_curp(i).z - m_oldp(i).z) * 0.4
        End If
    Next
    
    'first precomputations
    For i = 0 To num_body - 1
        'bounding box
        g_d3dx.ComputeBoundingBox m_curp(body(i).Part_Min), body(i).Part_Max - body(i).Part_Min, D3DFVF_NORMAL, body(i).bound_min, body(i).bound_max
        'centre of mass..
        body(i).centre_mass.x = 0
        body(i).centre_mass.y = 0
        body(i).centre_mass.z = 0
        For j = body(i).Part_Min To body(i).Part_Max
            body(i).centre_mass.x = body(i).centre_mass.x + m_curp(j).x / 8
            body(i).centre_mass.y = body(i).centre_mass.y + m_curp(j).y / 8
            body(i).centre_mass.z = body(i).centre_mass.z + m_curp(j).z / 8
        Next
    Next
    
    'now check all the bodies if their bounding boxes overlap...
    For i = 0 To num_body - 1
        For j = 0 To num_body - 1
            If (body(i).bound_min.x > body(j).bound_min.x And body(i).bound_min.x < body(j).bound_max.x) Or (body(i).bound_max.x > body(j).bound_min.x And body(i).bound_max.x < body(j).bound_max.x) Then
                If (body(i).bound_min.y > body(j).bound_min.y And body(i).bound_min.y < body(j).bound_max.y) Or (body(i).bound_max.y > body(j).bound_min.y And body(i).bound_max.y < body(j).bound_max.y) Then
                    If (body(i).bound_min.z > body(j).bound_min.z And body(i).bound_min.z < body(j).bound_max.z) Or (body(i).bound_max.z > body(j).bound_min.z And body(i).bound_max.z < body(j).bound_max.z) Then
                        'we have a bounding box collision, now examine in more detail...
                        
                        'super bogus for now...
                        
                        D3DXVec3Subtract delta, body(i).centre_mass, body(j).centre_mass
                        D3DXVec3Scale delta, delta, 0.005
                        'delta.x = 1 / (delta.x * 50)
                        'delta.y = 1 / (delta.y * 50)
                        'delta.z = 1 / (delta.z * 50)
                        
                        For a = body(i).Part_Min To body(i).Part_Max
                            'm_curp(a).x = m_curp(a).x - 5
                            D3DXVec3Add m_curp(a), m_curp(a), delta
                        Next
                        For a = body(j).Part_Min To body(j).Part_Max
                            'm_curp(a).x = m_curp(a).x - 5
                            D3DXVec3Subtract m_curp(a), m_curp(a), delta
                        Next
                    End If
                End If
            End If
        Next
    Next

End Function



Public Sub create_pyramid(x As Double, y As Double, z As Double, ln As Double)
    'malformed pyramid for now...
    body(num_body).Part_Min = num_particles + 1
    body(num_body).Part_Max = num_particles + 4
    body(num_body).Join_Min = num_join + 1
    body(num_body).Join_Min = num_join + 6
    num_body = num_body + 1
    
    Dim r1 As Double
    Dim r2 As Double
    
    r1 = Sqr(ln * ln - (ln / 2) * (ln / 2))
    r2 = Sqr(ln * ln - (r1 / 2) * (r1 / 2))
    
    m_curp(num_particles + 1).x = x
    m_curp(num_particles + 1).y = y
    m_curp(num_particles + 1).z = z
    
    m_curp(num_particles + 2).x = x + ln
    m_curp(num_particles + 2).y = y
    m_curp(num_particles + 2).z = z
    
    m_curp(num_particles + 3).x = x + ln / 2
    m_curp(num_particles + 3).y = y
    m_curp(num_particles + 3).z = z + r1
    
    m_curp(num_particles + 4).x = x + ln / 2
    m_curp(num_particles + 4).y = y + r2
    m_curp(num_particles + 4).z = z + r1 / 2
    
    Dim a As Long
    
    For a = num_particles + 1 To num_particles + 4
        m_oldp(a) = m_curp(a)
    Next
    
    join_p1(num_join + 1) = num_particles + 1
    join_p2(num_join + 1) = num_particles + 2
    join_rl(num_join + 1) = ln
    
    join_p1(num_join + 2) = num_particles + 2
    join_p2(num_join + 2) = num_particles + 3
    join_rl(num_join + 2) = ln
    
    join_p1(num_join + 3) = num_particles + 3
    join_p2(num_join + 3) = num_particles + 1
    join_rl(num_join + 3) = ln
    
    join_p1(num_join + 4) = num_particles + 1
    join_p2(num_join + 4) = num_particles + 4
    join_rl(num_join + 4) = ln
   
    join_p1(num_join + 5) = num_particles + 2
    join_p2(num_join + 5) = num_particles + 4
    join_rl(num_join + 5) = ln
    
    join_p1(num_join + 6) = num_particles + 3
    join_p2(num_join + 6) = num_particles + 4
    join_rl(num_join + 6) = ln
        
    'increment the counters...
    num_particles = num_particles + 4
    num_join = num_join + 6
    
    
End Sub
Public Sub create_box(x As Double, y As Double, z As Double, lx As Double, ly As Double, lz As Double)
    Dim a As Long
    Dim lxy As Double
    Dim lyz As Double
    Dim lxz As Double
    Dim lnn As Double
    
    body(num_body).Part_Min = num_particles + 1
    body(num_body).Part_Max = num_particles + 8
    body(num_body).Join_Min = num_join + 1
    body(num_body).Join_Max = num_join + 26
    num_body = num_body + 1
    
    
    lxy = Sqr(lx * lx + ly * ly)
    lyz = Sqr(ly * ly + lz * lz)
    lxz = Sqr(lx * lx + lz * lz)
    lnn = Sqr(lxy * lxy + lz * lz)
    'this creates a box with crossbracing at the location specified...
       
    
    m_curp(num_particles + 1).x = x
    m_curp(num_particles + 1).y = y
    m_curp(num_particles + 1).z = z
        
    m_curp(num_particles + 2).x = x
    m_curp(num_particles + 2).y = y + ly
    m_curp(num_particles + 2).z = z
    
    m_curp(num_particles + 3).x = x + lx
    m_curp(num_particles + 3).y = y + ly
    m_curp(num_particles + 3).z = z
    
    m_curp(num_particles + 4).x = x + lx
    m_curp(num_particles + 4).y = y
    m_curp(num_particles + 4).z = z
    
    m_curp(num_particles + 5).x = x
    m_curp(num_particles + 5).y = y
    m_curp(num_particles + 5).z = z + lz
    
    m_curp(num_particles + 6).x = x
    m_curp(num_particles + 6).y = y + ly
    m_curp(num_particles + 6).z = z + lz
    
    m_curp(num_particles + 7).x = x + lx
    m_curp(num_particles + 7).y = y + ly
    m_curp(num_particles + 7).z = z + lz
    
    m_curp(num_particles + 8).x = x + lx
    m_curp(num_particles + 8).y = y
    m_curp(num_particles + 8).z = z + lz
    
    For a = num_particles + 1 To num_particles + 8
        m_oldp(a) = m_curp(a)
    Next
    
    join_p1(num_join + 1) = num_particles + 1
    join_p2(num_join + 1) = num_particles + 2
    join_rl(num_join + 1) = ly
    
    join_p1(num_join + 2) = num_particles + 2
    join_p2(num_join + 2) = num_particles + 3
    join_rl(num_join + 2) = lx
    
    join_p1(num_join + 3) = num_particles + 3
    join_p2(num_join + 3) = num_particles + 4
    join_rl(num_join + 3) = ly
    
    join_p1(num_join + 4) = num_particles + 4
    join_p2(num_join + 4) = num_particles + 1
    join_rl(num_join + 4) = lx
   
    join_p1(num_join + 5) = num_particles + 5
    join_p2(num_join + 5) = num_particles + 6
    join_rl(num_join + 5) = ly
    
    join_p1(num_join + 6) = num_particles + 6
    join_p2(num_join + 6) = num_particles + 7
    join_rl(num_join + 6) = lx
    
    join_p1(num_join + 7) = num_particles + 7
    join_p2(num_join + 7) = num_particles + 8
    join_rl(num_join + 7) = ly
    
    join_p1(num_join + 8) = num_particles + 8
    join_p2(num_join + 8) = num_particles + 5
    join_rl(num_join + 8) = lx
    
    join_p1(num_join + 9) = num_particles + 1
    join_p2(num_join + 9) = num_particles + 5
    join_rl(num_join + 9) = lz
    
    join_p1(num_join + 10) = num_particles + 2
    join_p2(num_join + 10) = num_particles + 6
    join_rl(num_join + 10) = lz
    
    join_p1(num_join + 11) = num_particles + 3
    join_p2(num_join + 11) = num_particles + 7
    join_rl(num_join + 11) = lz
    
    join_p1(num_join + 12) = num_particles + 4
    join_p2(num_join + 12) = num_particles + 8
    join_rl(num_join + 12) = lz
    
    join_p1(num_join + 13) = num_particles + 1
    join_p2(num_join + 13) = num_particles + 3
    join_rl(num_join + 13) = lxy
    
    join_p1(num_join + 14) = num_particles + 3
    join_p2(num_join + 14) = num_particles + 8
    join_rl(num_join + 14) = lyz
    
    join_p1(num_join + 15) = num_particles + 2
    join_p2(num_join + 15) = num_particles + 5
    join_rl(num_join + 15) = lyz
    
    join_p1(num_join + 16) = num_particles + 4
    join_p2(num_join + 16) = num_particles + 5
    join_rl(num_join + 16) = lxz

    join_p1(num_join + 17) = num_particles + 2
    join_p2(num_join + 17) = num_particles + 7
    join_rl(num_join + 17) = lxz
    
    join_p1(num_join + 18) = num_particles + 6
    join_p2(num_join + 18) = num_particles + 8
    join_rl(num_join + 18) = lxy

    join_p1(num_join + 19) = num_particles + 5
    join_p2(num_join + 19) = num_particles + 7
    join_rl(num_join + 19) = lxy

    join_p1(num_join + 20) = num_particles + 4
    join_p2(num_join + 20) = num_particles + 7
    join_rl(num_join + 20) = lyz

    join_p1(num_join + 21) = num_particles + 1
    join_p2(num_join + 21) = num_particles + 6
    join_rl(num_join + 21) = lyz

    join_p1(num_join + 22) = num_particles + 1
    join_p2(num_join + 22) = num_particles + 7
    join_rl(num_join + 22) = lnn
    
    join_p1(num_join + 23) = num_particles + 4
    join_p2(num_join + 23) = num_particles + 6
    join_rl(num_join + 23) = lnn
    
    join_p1(num_join + 24) = num_particles + 2
    join_p2(num_join + 24) = num_particles + 4
    join_rl(num_join + 24) = lxy
    
    join_p1(num_join + 25) = num_particles + 8
    join_p2(num_join + 25) = num_particles + 2
    join_rl(num_join + 25) = lnn

    join_p1(num_join + 26) = num_particles + 3
    join_p2(num_join + 26) = num_particles + 5
    join_rl(num_join + 26) = lnn
    
    
    'increment the counters...
    num_particles = num_particles + 8
    num_join = num_join + 26
    
End Sub

