VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   8595
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   9885
   Icon            =   "BUGS.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   8595
   ScaleWidth      =   9885
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox Picture1 
      Height          =   7815
      Left            =   165
      ScaleHeight     =   517
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   630
      TabIndex        =   1
      Top             =   180
      Width           =   9510
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Command1"
      Height          =   435
      Left            =   180
      TabIndex        =   0
      Top             =   8130
      Width           =   1620
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Dim m_matView As D3DMATRIX
'Dim m_matOrientation As D3DMATRIX

Dim dwn%
Dim mx As Long
Dim my As Long
Dim ox As Long
Dim oy As Long

Private Type CUSTOMVERTEX
    v As D3DVECTOR
    n As D3DVECTOR
    color As Long
    tu As Single
    tv As Single
End Type
Const D3DFVF_COLORVERTEX = (D3DFVF_XYZ Or D3DFVF_DIFFUSE Or D3DFVF_TEX1 Or D3DFVF_NORMAL)

Dim m_ParticleTexture As Direct3DTexture8
Dim m_ShadowTexture As Direct3DTexture8

Dim m_VertB As Direct3DVertexBuffer8
Dim m_VertI As Direct3DIndexBuffer8

Dim m_frame As CD3DFrame
Dim Animation As CD3DAnimation
Dim m_boxes As Integer

Dim m_GroundTexture As Direct3DTexture8
Dim m_NumGroundVertices As Long
Dim m_NumGroundIndices As Long
Dim m_GroundIB As Direct3DIndexBuffer8
Dim m_GroundVB As Direct3DVertexBuffer8
Dim m_planeGround As D3DPLANE

Dim camera_mode As Long

Const GROUND_GRIDSIZE = 16
Const GROUND_WIDTH = 1024
Const GROUND_HEIGHT = 1024
Const GROUND_TILE = 6
Const GROUND_COLOR = &HBBEEEEEE

Dim m_Verts() As CUSTOMVERTEX
Dim m_Verts2() As CUSTOMVERTEX
Dim m_grVerts() As CUSTOMVERTEX
Dim m_grVerts2() As CUSTOMVERTEX
Const m_MaxParticles = 128
Private Declare Function GetTickCount Lib "kernel32" () As Long

Dim m_run

Dim keyarray(300) As Integer
Private Sub check_keys()
    Dim v As D3DVECTOR
    Dim v2 As D3DVECTOR
    Dim m As D3DMATRIX
    Dim k As Long
    
    If keyarray(vbKeyLeft) Then
        D3DXMatrixIdentity m
        D3DXMatrixRotationY m, -10 * m_timeStep
        For k = 1 To 8
            D3DXVec3Subtract v, m_curp(k), body(0).centre_mass
            'v is now relative to the centre of the box
            D3DXVec3TransformNormal v, v, m
            'now put it back
            D3DXVec3Add m_curp(k), v, body(0).centre_mass
            'update the old particle position
            m_oldp(k).x = m_curp(k).x
            m_oldp(k).z = m_curp(k).z
        Next
    End If
    If keyarray(vbKeyRight) Then
        D3DXMatrixIdentity m
        D3DXMatrixRotationY m, 10 * m_timeStep
        For k = 1 To 8
            D3DXVec3Subtract v, m_curp(k), body(0).centre_mass
            'v is now relative to the centre of the box
            D3DXVec3TransformNormal v, v, m
            'now put it back
            D3DXVec3Add m_curp(k), v, body(0).centre_mass
            m_oldp(k) = m_curp(k)
        Next
    End If
    If keyarray(vbKeyUp) Then
        D3DXVec3Subtract v, m_curp(5), m_curp(1)
        D3DXVec3Scale v, v, -20 * m_timeStep
        v.y = 0
        If m_curp(1).y > m_curp(2).y Then
            'whoops upside down..
            m_curp(1).y = m_curp(1).y + (m_curp(1).y - m_curp(2).y) / 50
            m_curp(4).y = m_curp(4).y + (m_curp(1).y - m_curp(2).y) / 50
        End If
        For k = 1 To 8
            D3DXVec3Add m_curp(k), m_curp(k), v
            D3DXVec3Add m_oldp(k), m_oldp(k), v
        Next
    End If
    If keyarray(vbKeyDown) Then
        D3DXVec3Subtract v, m_curp(5), m_curp(1)
        D3DXVec3Scale v, v, 20 * m_timeStep
        v.y = 0
        For k = 1 To 8
            D3DXVec3Add m_curp(k), m_curp(k), v
            D3DXVec3Add m_oldp(k), m_oldp(k), v
        Next
    End If
End Sub


Private Sub Command1_Click()
    Dim a%, cnt As Long
    Dim v As CUSTOMVERTEX
    Dim t As Long, i As Long
    Dim anim As Double
    Dim vec As D3DVECTOR
    Dim vec_to As D3DVECTOR
    Dim vec_from As D3DVECTOR
    
    If m_run = False Then
        m_run = True
        t = GetTickCount - 10
        Do
        
            m_timeStep = (GetTickCount() - t) / 4000
            anim = anim + m_timeStep * 500
            'Animation.SetTime (anim)
            t = GetTickCount
            
            'position the camera
            If camera_mode = 0 Then
                'first bug mode...
                D3DXVec3Subtract vec, m_curp(4), m_curp(1)
                D3DXVec3Scale vec, vec, 0.5
                D3DXVec3Add vec_to, m_curp(6), vec
                D3DXVec3Add vec_from, m_curp(2), vec
                D3DUtil_SetupCamera vec_to, vec_from, vec3(0, 1, 0)
            ElseIf camera_mode = 1 Then
                '3rd bug mode
                D3DXVec3Subtract vec, vec_from, body(0).centre_mass
                D3DXVec3Scale vec, vec, 0.25
                D3DXVec3Subtract vec_to, vec_from, vec
                
                D3DUtil_SetupCamera vec_from, vec_to, vec3(0, 1, 0)
                
                'animate the vec_from...
                D3DXVec3Normalize vec, vec
                D3DXVec3Scale vec, vec, 60
                D3DXVec3Add vec, body(0).centre_mass, vec
                vec.y = vec.y + 25
                
                D3DXVec3Lerp vec_from, vec_from, vec, 0.02
            ElseIf camera_mode = 2 Then
                'far away camera...
                vec_from = vec3(0, 120, -400)
                
                D3DXVec3Subtract vec, vec_from, body(0).centre_mass
                D3DXVec3Scale vec, vec, 0.25
                D3DXVec3Subtract vec_to, vec_from, vec
                
                D3DUtil_SetupCamera vec_from, vec_to, vec3(0, 1, 0)
            End If
            
            'check the keys pressed
            check_keys
            
            'do a physics engine tick
            TimeStep
            
            'Start the Scene
            g_dev.BeginScene
            
            'clear the buffer
            D3DUtil_ClearAll 0
            
            g_dev.SetRenderState D3DRS_ZWRITEENABLE, 1
            g_dev.SetRenderState D3DRS_ZENABLE, 1 'False
            g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 0
            g_dev.SetRenderState D3DRS_CLIPPLANEENABLE, 0 'FALSE
            g_dev.SetRenderState D3DRS_LIGHTING, 1
            
            ' Draw ground
            g_dev.SetTexture 0, m_GroundTexture
            g_dev.SetVertexShader D3DFVF_COLORVERTEX
            g_dev.SetStreamSource 0, m_GroundVB, Len(v)
            g_dev.SetIndices m_GroundIB, 0
            g_dev.DrawIndexedPrimitive D3DPT_TRIANGLELIST, 0, m_NumGroundVertices, 0, (m_NumGroundIndices / 3)


            Dim m As D3DMATRIX
            Dim m2 As D3DMATRIX
            
            'draw the bugs
            For i = 0 To num_body - 1
            
                If camera_mode = 0 And i = 0 Then
                    'dont draw our bug in 'first bug' mode
                Else
                                   
                    'first set up the scaling of the mesh
                    'so it fits our cube...
                    D3DXMatrixScaling m, (join_rl(body(i).Join_Min + 1)) * 0.013, (join_rl(body(i).Join_Min)) * 0.03, (join_rl(body(i).Join_Min + 9)) * 0.012
                    
                    'now include the rotation of the cube
                    D3DXMatrixMultiply m, m, body(i).rot ' m3
                    
                    'finally the translation of the mesh to move to the xyz position of the box
                    D3DXMatrixTranslation m2, m_curp(body(i).Part_Min).x, m_curp(body(i).Part_Min).y, m_curp(body(i).Part_Min).z
                    D3DXMatrixMultiply m, m, m2
                    
                    'update the mesh position using the matrix
                    m_frame.SetMatrix m
                    
                    'render the mesh
                    m_frame.Render g_dev
                End If
                
            Next
            
            
            
            'draw a shadow..
            Dim sz As Double
            Dim cl As Long
            ReDim m_Verts(num_body * 6)
            For i = 0 To num_body - 1
                If body(i).Part_Max - body(i).Part_Min = 7 Then 'the primitive is a cube...
                    sz = join_rl(body(i).Join_Min + 1) / Log(body(i).centre_mass.y + 0.01)
                    cl = body(i).centre_mass.y
                    If cl < 0 Then cl = 0
                    If cl > 255 Then cl = 255
                    cl = RGB(cl, cl, cl)
                    'project the surface down the y axis...
                    m_Verts(i * 6 + 0).v.x = body(i).centre_mass.x - sz
                    m_Verts(i * 6 + 0).v.z = body(i).centre_mass.z - sz
                    m_Verts(i * 6 + 0).v.y = 1
                    m_Verts(i * 6 + 0).n.y = 1
                    m_Verts(i * 6 + 0).tu = 0
                    m_Verts(i * 6 + 0).tv = 0
                    m_Verts(i * 6 + 0).color = cl

                    m_Verts(i * 6 + 1).v.x = body(i).centre_mass.x - sz
                    m_Verts(i * 6 + 1).v.z = body(i).centre_mass.z + sz
                    m_Verts(i * 6 + 1).v.y = 1
                    m_Verts(i * 6 + 1).n.y = 1
                    m_Verts(i * 6 + 1).tu = 0
                    m_Verts(i * 6 + 1).tv = 1
                    m_Verts(i * 6 + 1).color = cl

                    m_Verts(i * 6 + 2).v.x = body(i).centre_mass.x + sz
                    m_Verts(i * 6 + 2).v.z = body(i).centre_mass.z + sz
                    m_Verts(i * 6 + 2).v.y = 1
                    m_Verts(i * 6 + 2).n.y = 1
                    m_Verts(i * 6 + 2).tu = 1
                    m_Verts(i * 6 + 2).tv = 1
                    m_Verts(i * 6 + 2).color = cl

                    m_Verts(i * 6 + 3).v.x = body(i).centre_mass.x - sz
                    m_Verts(i * 6 + 3).v.z = body(i).centre_mass.z - sz
                    m_Verts(i * 6 + 3).v.y = 1
                    m_Verts(i * 6 + 3).n.y = 1
                    m_Verts(i * 6 + 3).tu = 0
                    m_Verts(i * 6 + 3).tv = 0
                    m_Verts(i * 6 + 3).color = cl

                    m_Verts(i * 6 + 4).v.x = body(i).centre_mass.x + sz
                    m_Verts(i * 6 + 4).v.z = body(i).centre_mass.z + sz
                    m_Verts(i * 6 + 4).v.y = 1
                    m_Verts(i * 6 + 4).n.y = 1
                    m_Verts(i * 6 + 4).tu = 1
                    m_Verts(i * 6 + 4).tv = 1
                    m_Verts(i * 6 + 4).color = cl

                    m_Verts(i * 6 + 5).v.x = body(i).centre_mass.x + sz
                    m_Verts(i * 6 + 5).v.z = body(i).centre_mass.z - sz
                    m_Verts(i * 6 + 5).v.y = 1
                    m_Verts(i * 6 + 5).n.y = 1
                    m_Verts(i * 6 + 5).tu = 1
                    m_Verts(i * 6 + 5).tv = 0
                    m_Verts(i * 6 + 5).color = cl
                End If
            Next
            
            g_dev.SetTexture 0, m_ShadowTexture
            g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 1
            'g_dev.SetTextureStageState 0, D3DTSS_COLOROP, D3DTOP_SUBTRACT
            g_dev.SetTextureStageState 0, D3DTSS_ALPHAOP, D3DTOP_SUBTRACT
            g_dev.SetRenderState D3DRS_SRCBLEND, D3DBLEND_SRCALPHA
            g_dev.SetRenderState D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA
            'g_dev.SetRenderState D3DRS_SRCBLEND, D3DBLEND_SRCCOLOR
            'g_dev.SetRenderState D3DRS_DESTBLEND, D3DBLEND_ONE
            g_dev.SetVertexShader D3DFVF_COLORVERTEX
            g_dev.SetStreamSource 0, m_VertB, Len(v)
            D3DVertexBuffer8SetData m_VertB, 0, Len(v) * (num_body) * 6, 0, m_Verts(0)
            g_dev.DrawPrimitive D3DPT_TRIANGLELIST, 0, (num_body) * 2
            
            g_dev.SetTextureStageState 0, D3DTSS_COLOROP, D3DTOP_MODULATE
            
            
            If m_boxes Then
                g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 1
                g_dev.SetTextureStageState 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE
                g_dev.SetRenderState D3DRS_SRCBLEND, D3DBLEND_INVSRCCOLOR
                g_dev.SetRenderState D3DRS_DESTBLEND, D3DBLEND_ONE
                       
                g_dev.SetRenderState D3DRS_POINTSPRITE_ENABLE, 1 'True
                g_dev.SetRenderState D3DRS_POINTSCALE_ENABLE, 1
                
                g_dev.SetTexture 0, m_ParticleTexture
                
                g_dev.SetStreamSource 0, m_VertB, Len(v)
                g_dev.SetVertexShader D3DFVF_COLORVERTEX
                
                
                Dim DWFloat0 As Long
                Dim DWFloat1 As Long
                Dim DWFloatp08 As Long
                DWFloat0 = FtoDW(0.1)
                DWFloat1 = FtoDW(1)
                DWFloatp08 = FtoDW(5)
                ' Set the render states for using point sprites
                g_dev.SetRenderState D3DRS_POINTSIZE, DWFloatp08
                g_dev.SetRenderState D3DRS_POINTSIZE_MIN, DWFloat0
                g_dev.SetRenderState D3DRS_POINTSCALE_A, DWFloat0
                g_dev.SetRenderState D3DRS_POINTSCALE_B, DWFloat0
                g_dev.SetRenderState D3DRS_POINTSCALE_C, DWFloat1
                
                ReDim m_Verts(m_MaxParticles * 2)
                                
                'Render the corners
                cnt = 0
                For a% = 0 To num_particles - 1
                    'Form1.Picture1.Line (m_curp(a%).x + 100, m_curp(a%).y + 100)-Step(2, 2), 0, BF
                    m_Verts(cnt).v = m_curp(a% + 1)
                    m_Verts(cnt).n.y = 1
                    m_Verts(cnt).color = &HFFFFFFFF
                    cnt = cnt + 1
                    If cnt = m_MaxParticles Then
                        D3DVertexBuffer8SetData m_VertB, 0, Len(v) * cnt, 0, m_Verts(0)
                        g_dev.DrawPrimitive D3DPT_POINTLIST, 0, cnt
                        cnt = 0
                    End If
                Next
                D3DVertexBuffer8SetData m_VertB, 0, Len(v) * cnt, 0, m_Verts(0)
                g_dev.DrawPrimitive D3DPT_POINTLIST, 0, cnt
            
                g_dev.SetRenderState D3DRS_POINTSPRITE_ENABLE, 0
                g_dev.SetRenderState D3DRS_POINTSCALE_ENABLE, 0
                g_dev.SetRenderState D3DRS_ALPHABLENDENABLE, 0
            
                'Render the edges
                cnt = 0
                For a% = 0 To num_join - 1
                    m_Verts(cnt * 2).v = m_curp(join_p1(a% + 1))
                    m_Verts(cnt * 2).color = &HFFFFFFFF
                    m_Verts(cnt * 2 + 1).v = m_curp(join_p2(a% + 1))
                    m_Verts(cnt * 2 + 1).color = &HFFFFFFFF
                    cnt = cnt + 1
                    If cnt = m_MaxParticles Then
                        D3DVertexBuffer8SetData m_VertB, 0, Len(v) * cnt * 2, 0, m_Verts(0)
                        g_dev.DrawPrimitive D3DPT_LINELIST, 0, cnt * 2
                        cnt = 0
                    End If
                Next
                'whats left
                D3DVertexBuffer8SetData m_VertB, 0, Len(v) * cnt * 2, 0, m_Verts(0)
                g_dev.DrawPrimitive D3DPT_LINELIST, 0, cnt * 2
            End If
            
            
            
            'End the scene
            g_dev.EndScene
            
            'update the screen...
            D3DUtil_PresentAll g_focushwnd
            
            
          DoEvents
        Loop Until m_run = False
    End If
    
End Sub

Private Sub initialiseD3D()
    Dim v As CUSTOMVERTEX
    
    'setup D3d
    m_binit = D3DUtil_Init(Picture1.hwnd, True, 0, 0, D3DDEVTYPE_HAL, Me)
    
    'D3DXMatrixTranslation m_matView, 0, 0, 10
    'D3DXMatrixTranslation m_matOrientation, 0, 0, 0
    
    'Set up some lights and camera
    g_lWindowWidth = Picture1.ScaleWidth
    g_lWindowHeight = Picture1.ScaleHeight
    D3DUtil_SetupDefaultScene
    
    Set m_ParticleTexture = D3DUtil_CreateTexture(g_dev, App.path & "\Particle.bmp", D3DFMT_UNKNOWN)
    Set m_ShadowTexture = D3DUtil_CreateTexture(g_dev, App.path & "\shadow.dds", D3DFMT_UNKNOWN)
    
    Set m_VertB = Nothing
    Set m_VertB = g_dev.CreateVertexBuffer(4 * m_MaxParticles * Len(v), 0, D3DFVF_COLORVERTEX, D3DPOOL_MANAGED)
    
       
    'position the camera
    D3DUtil_SetupCamera vec3(0, 0, -300), vec3(0, 0, -200), vec3(0, 1, 0)
    
    
    'load our mesh...
    Set m_frame = New CD3DFrame
    Set Animation = New CD3DAnimation
    m_frame.InitFromFile g_dev, App.path + "\bug.x", Nothing, Animation


    Set m_GroundTexture = Nothing
    Set m_GroundTexture = D3DUtil_CreateTexture(g_dev, App.path & "\concrete.dds", D3DFMT_UNKNOWN)
    m_NumGroundVertices = (GROUND_GRIDSIZE + 1) * (GROUND_GRIDSIZE + 1)
    m_NumGroundIndices = (GROUND_GRIDSIZE * GROUND_GRIDSIZE) * 6
    Set m_GroundVB = Nothing
    Set m_GroundIB = Nothing
    m_planeGround = D3DPLANE4(0, 1, 0, 0)
    
    ' Create vertex buffer for ground object
    Set m_GroundVB = g_dev.CreateVertexBuffer(m_NumGroundVertices * Len(v), 0, D3DFVF_COLORVERTEX, D3DPOOL_MANAGED)
        

    ' Fill vertex buffer
    
     Dim zz As Long, xx As Long
     
     ReDim m_grVerts(GROUND_GRIDSIZE * GROUND_GRIDSIZE * 6)
     
     
     i = 0
     For zz = 0 To GROUND_GRIDSIZE
        For xx = 0 To GROUND_GRIDSIZE
            
            m_grVerts(i).v.x = GROUND_WIDTH * ((xx / GROUND_GRIDSIZE) - 0.5)
            m_grVerts(i).v.y = 0
            m_grVerts(i).v.z = GROUND_HEIGHT * ((zz / GROUND_GRIDSIZE) - 0.5)
            m_grVerts(i).color = GROUND_COLOR
            m_grVerts(i).tu = xx * (GROUND_TILE / GROUND_GRIDSIZE)
            m_grVerts(i).tv = zz * (GROUND_TILE / GROUND_GRIDSIZE)
            m_grVerts(i).n.y = 1
            i = i + 1
        Next
    Next

    D3DVertexBuffer8SetData m_GroundVB, 0, Len(v) * (GROUND_GRIDSIZE + 1) * (GROUND_GRIDSIZE + 1), 0, m_grVerts(0)
    
    Dim vtx As Long
    Dim m_Indices() As Integer
    ReDim m_Indices(m_NumGroundIndices * 4)
    Dim z As Long, x As Long
    
    ' Create the index buffer
    Set m_GroundIB = g_dev.CreateIndexBuffer(m_NumGroundIndices * 2, 0, D3DFMT_INDEX16, D3DPOOL_MANAGED)
            
    ' Fill in indices
    i = 0
    For z = 0 To GROUND_GRIDSIZE - 1
        For x = 0 To GROUND_GRIDSIZE - 1
                
                vtx = x + z * (GROUND_GRIDSIZE + 1)
                m_Indices(i) = vtx + 1: i = i + 1
                m_Indices(i) = vtx + 0: i = i + 1
                m_Indices(i) = vtx + 0 + (GROUND_GRIDSIZE + 1): i = i + 1
                m_Indices(i) = vtx + 1: i = i + 1
                m_Indices(i) = vtx + 0 + (GROUND_GRIDSIZE + 1): i = i + 1
                m_Indices(i) = vtx + 1 + (GROUND_GRIDSIZE + 1): i = i + 1
            
        Next
    Next
    
    D3DIndexBuffer8SetData m_GroundIB, 0, 2 * m_NumGroundIndices, 0, m_Indices(0)
    
    g_dev.SetTextureStageState 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1
    g_dev.SetTextureStageState 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE
    g_dev.SetTextureStageState 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR
    g_dev.SetTextureStageState 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR
    
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    keyarray(KeyCode) = 1
    
    If KeyCode = vbKeyF1 Then camera_mode = 0
    If KeyCode = vbKeyF2 Then camera_mode = 1
    If KeyCode = vbKeyF3 Then camera_mode = 2
End Sub

Private Sub Form_KeyUp(KeyCode As Integer, Shift As Integer)
    keyarray(KeyCode) = 0
End Sub

Private Sub Form_Load()
    Me.Show
    DoEvents
    Dim a As Long
    Dim b As Long
    
    'call the init routine
    initialiseD3D
        
    'm_boxes = True
    ox = 0
    oy = -200
    camera_mode = 2
        
    'create geometry
    create_box -50, 110, 55, 20, 10, 20
      
    Randomize
    For a = 1 To 15
        b = Int(Rnd(1) * 30) + 30
        create_box Int(Rnd(1) * 300) - 150, Int(Rnd(1) * 300) + 150, Int(Rnd(1) * 60) - 30, (b), (b / 2), (b)
    Next
    
    
    m_timeStep = 0.05
    m_grav.y = -5
    
   
    
End Sub

Sub DeleteDeviceObjects()
    Set m_ParticleTexture = Nothing
    Set m_ShadowTexture = Nothing
    Set Animation = Nothing
        
    Set m_GroundTexture = Nothing
    Set m_GroundVB = Nothing
    Set m_GroundIB = Nothing

    
    Set g_Mesh = Nothing
    
End Sub

Private Sub Form_Unload(Cancel As Integer)
    m_run = False
    DeleteDeviceObjects
End Sub

Private Sub Picture1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    dwn% = True
    mx = x
    my = y
End Sub

Private Sub Picture1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    If dwn% Then
         ox = ox - (mx - x)
         oy = oy - (my - y)
         mx = x
         my = y
         D3DUtil_SetupCamera vec3(0, 200, (oy)), vec3((ox), 0, 0), vec3(0, 1, 0)
    End If
End Sub

Private Sub Picture1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    dwn% = False
End Sub
